# This code is part of Perl distribution OODoc version 3.06.
# The POD got stripped from this file by OODoc version 3.06.
# For contributors see file ChangeLog.

# This software is copyright (c) 2003-2026 by Mark Overmeer.

# This is free software; you can redistribute it and/or modify it under
# the same terms as the Perl 5 programming language system itself.
# SPDX-License-Identifier: Artistic-1.0-Perl OR GPL-1.0-or-later


package OODoc::Text::Option;{
our $VERSION = '3.06';
}

use parent 'OODoc::Text';

use strict;
use warnings;

use Log::Report    'oodoc';

#--------------------

sub init($)
{	my ($self, $args) = @_;
	$args->{type}    ||= 'Option';
	$args->{container} = delete $args->{subroutine} or panic;

	$self->SUPER::init($args) or return;

	$self->{OTO_parameters} = delete $args->{parameters} or panic;
	$self;
}

sub publish($)
{	my ($self, $args) = @_;
	my $exporter = $args->{exporter};

	my $p = $self->SUPER::publish($args);
	$p->{params} = $exporter->markupString($self->parameters);
	$p;
}

#--------------------

sub subroutine() { $_[0]->container }


sub parameters() { $_[0]->{OTO_parameters} }

1;
