# This code is part of Perl distribution OODoc version 3.06.
# The POD got stripped from this file by OODoc version 3.06.
# For contributors see file ChangeLog.

# This software is copyright (c) 2003-2026 by Mark Overmeer.

# This is free software; you can redistribute it and/or modify it under
# the same terms as the Perl 5 programming language system itself.
# SPDX-License-Identifier: Artistic-1.0-Perl OR GPL-1.0-or-later


package OODoc::Object;{
our $VERSION = '3.06';
}


use strict;
use warnings;

use Log::Report    'oodoc';

use List::Util     qw/first/;

#--------------------

use overload
	'=='   => sub {$_[0]->unique == $_[1]->unique},
	'!='   => sub {$_[0]->unique != $_[1]->unique},
	'bool' => sub {1};

#--------------------

sub new(@)
{	my ($class, %args) = @_;
	my $self = (bless {}, $class)->init(\%args);

	if(my @missing = keys %args)
	{	error __xn"unknown object attribute '{names}' for {pkg}", "unknown object attributes for {pkg}: {names}",
			scalar @missing, names => \@missing, pkg => $class;
	}

	$self;
}

my $unique = 42;

sub init($)
{	my ($self, $args) = @_;

	# prefix with 'id', otherwise confusion between string and number
	$self->{OO_unique} = 'id' . $unique++;
	$self;
}

#--------------------

sub unique() { $_[0]->{OO_unique} }


sub manual() { panic }

#--------------------

my $index;  # still a global :-(  Set by ::Export
sub _publicationIndex($) { $index = $_[1] }

sub publish($)
{	my ($self, $args) = @_;
	my $id     = $self->unique;

	my $manual = $args->{manual};
	$id .= '-' . $manual->unique if $manual->inherited($self);

	$index->{$id} = +{ id => $id };
}

1;
