#!/usr/bin/perl

use strict;
use warnings;

use Mail::Message;
use Mail::Message::Field::Full;
use Mail::Transport::SMTP;
use Data::Dumper;
use Encode;


my $subject = 'Это длинный заголовок тестового письма!';
my $charset = 'utf-8';
$charset = decode_utf8($charset);
$subject = decode_utf8($subject);

my $from_name = 'Дима';
$from_name = Encode::decode_utf8($from_name);
my $from_address = Mail::Message::Field::Address->new(
    address  => 'dima@mailbox.ru',
    phrase   => $from_name,
    charset  => $charset,
    encoding => 'B',
);

my $to_name = 'markov';
$to_name = Encode::decode_utf8($to_name);
my $to_address = Mail::Message::Field::Address->new(
    address  => 'test@mailbox.ru',
    phrase   => $to_name,
    charset  => $charset,
    encoding => 'B',
);


my $head = Mail::Message::Head->build(
    Mail::Message::Field::Full->new('from' => $from_address),
    Mail::Message::Field::Full->new('to' => $to_address),
    Mail::Message::Field::Full->new('subject' => $subject, charset => $charset, encoding => 'B'),
);

my $text = "Тело письма на русском языке.";
$text = decode_utf8($text);
$text = encode_utf8($text);

my $body = Mail::Message::Body->new(
    data      => $text,
    mime_type => 'text/plain',
    charset   => $charset,
);

$body = $body->concatenate($body, "\n-- \n", 'signature');

my $data = "текст приложения\n";
$data = decode_utf8($data);
$data = encode_utf8($data);

my $attach = Mail::Message::Body->new(
    data        => $data,
    disposition => 'inline',
    mime_type   => 'text/plain',
    charset     => $charset,
);
$body = $body->attach($attach);

my $message = Mail::Message->build($body, head => $head);

print $message->string;

exit 0;



