#!/usr/bin/env perl

use strict;
use warnings;

use Mail::Box::Manager;
use MIME::WordDecoder;


# Constructors
my $worddecoder = default MIME::WordDecoder;

my $mgr    = Mail::Box::Manager->new;
my $mailpath = "testmailbox";
my $folder     = $mgr->open(folder => $mailpath, access => "rw");


# Get the number of messages in scalar context.
my $emails = $folder->messages;
print "No of emails: $emails\n";

# Iterate over the messages.
my $first = 0;
my $now = time;
for my $count ($first .. $emails - 1) {
  my $msg = $folder->message($count);
  next unless $msg;


  # using study works fine

  my $subject = $msg->study("subject");         # The message's subject
  print "STUDY subject: $subject\n";
  print "TOP subject: ",$msg->subject, "\n";

  # but using get and default MIME::WordDecoder is not fine

  $subject = $msg->subject;         # The message's subject
  print "RAW subject: $subject\n";
  $subject = $worddecoder->decode($subject);
use warnings;
  print "WDEC subject: $subject\n";
}

$folder->close;
