package Mail::Folder::Netscape;
require 5.004;
use IO::Handle;
use Mail::Folder;
use Date::Format;
use Carp;
# use AutoLoader qw(AUTOLOAD);

{
  package Mail::Folder;
  sub my_get_fields
  {
   my $self = shift;
   my $num  = shift;
   my $hdr  = $self->get_header($num);
   my @results;
   while (@_)
    {
      my $val = $hdr->get(shift);
     push(@results,$val || '');
    }
   return (wantarray) ? @results : $results[0];
  }
  *get_fields = \&my_get_fields unless (Mail::Folder->can('get_fields'));
}


sub NS_DELETED () { 8 }
sub NS_READ    () { 1 }
sub NS_FLAGGED () { 4 }

my $MAGIC = "# Netscape folder cache\r\n";

use strict;

use vars qw($verbose);

$verbose = 0;

use IO::File;
use vars qw($VERSION @ISA $folder_id);
use Mail::Internet;
use Carp;
use Date::Parse;
use Time::ParseDate;
use Mail::Status qw(statusdb syncdb);

@ISA = qw(Mail::Folder);

if (Mail::Folder->can('register_type'))
 {
  Mail::Folder->register_type('netscape');
 }
else
 {
  Mail::Folder::register_folder_type('Mail::Folder::Netscape', 'netscape');
 }


$VERSION = "0.02";

sub ns_get_string
{
 my $fh = shift;
 my $val = '';
 my $off = 0;
 while (read($fh,$val,1,$off))
  {
   last if substr($val,$off,1) eq "\0";
   $off++;
  }
 chop($val);
 return $val;
}

sub ns_get_long
{
 my $fh = shift;
 my $val='';
 read($fh,$val,4) || die "Cannot read:$!";
 return unpack("N",$val);
}

sub ns_put_long
{
 my $fh = shift;
 print $fh pack('N',shift);
}

sub ns_put_short
{
 my $fh = shift;
 my $val = shift;
 die("No value") unless defined $val;
 print $fh pack('n',$val);
}

sub ns_get_short
{
 my $fh = shift;
 my $val='';
 read($fh,$val,2) || die("Cannot read:$!");
 $val  = unpack('n',$val);
 $val += 32768 if ($val < 0);
 return $val;
}

sub is_valid_folder_format
{
 my ($default,$path) = @_;
 print "default is $default\n";
 return 0 unless (-f $path);
 return 0 unless (-r $path);
 return 0 unless (-T $path);
 local *FH;
 return 0 unless open(FH,$path);
 binmode(FH);
 my $line = '';
 my $count = read(FH,$line,5);
 return $count == 5 && $line eq 'From ';
}

sub get_message_file
{
 my ($self,$num) = @_;
 $self->{'Files'} = [] unless exists $self->{'Files'};
 unless (defined $self->{'Files'}[$num])
  {
   my $mail = $self->get_message($num);
   if ($mail)
    {
     my $path = sprintf("%s.%d.$$",$self->foldername,$num+0);
     $path =~ s#(.*)/#/tmp/#;
     my $fh = \ do { local *MSGFILE };
     open($fh,">$path") || croak("Cannot open $path:$!");
     $mail->print($fh);
     close($fh);
     $self->{'Files'}[$num] = $path;
     return $path;
    }
  }
 return $self->{'Files'}[$num];
}

sub _summary
{
 my ($self,$num) = @_;
 return undef unless exists $self->{'Summary'};
 return undef unless $num < @{$self->{'Summary'}{'Messages'}};
 return $self->{'Summary'}{'Messages'}[$num];
}


sub message_time
{
 my ($self,$num) = @_;
 my $info = $self->_summary($num);
 return time() unless $info;
 return $info->{'time'};
}

sub message_date
{
 return localtime(shift->message_time);
}

sub message_subject
{
 my ($self,$num) = @_;
 my $info = $self->_summary($num);
 return '' unless $info;
 return $info->{'Subject'} || '';
}

sub message_sender
{
 my ($self,$num) = @_;
 my $info = $self->_summary($num);
 return '' unless $info;
 return $info->{'From'} || '';
}

sub encode_time
{
 my $t   = shift;
 my $now = time();
 if (($now - $t) <= 28*24*60*60)
  {
   return time2str("%a %o %h %H:%M",$t);
  }
 else
  {
   return time2str("%Y/%m/%d %H:%M",$t);
  }
}

sub get_fields
{
 local $verbose = 1;
 my $self = shift;
 my $num  = shift;
 my $info = $self->_summary($num);
 # print 'get(',join(',',$self,$num,$info,@_),")\n";
 return $self->SUPER::get($num,@_) unless $info;
 my @results;
 while (@_)
  {
   my $key = shift(@_);
   my $val;
   if ($key eq 'Date')
    {
     my $t = $info->{'time'};
     $val  = encode_time($t);
    }
   else
    {
     if (exists $info->{$key})
      {
       $val = $info->{$key};
      }
     else
      {
       warn "No cached $key\n";
       $val = $self->SUPER::get_fields($num,$key);
      }
    }
   push(@results,$val || '');
  }
 return (wantarray) ? @results : $results[0];
}

sub getFH
{
 my $self = shift;
 my $fh = \do { local *FH};
 my $path  = $self->{'PathName'};
 croak("$path is a directory") if -d $path;
 if (open($fh,"+<$path"))
  {
   binmode($fh);
   if (@_)
    {
     my ($posn,$whence) = @_;
     seek($fh,$posn,$whence);
    }
   return $fh;
  }
 warn("Cannot open $path:$!");
 return undef;
}

sub get_message
{
 my ($self,$num) = @_;
 my $info = $self->_summary($num);
 return undef unless $info;
 my $msg = $info->{'message'};
 unless (defined $msg)
  {
   warn "Reading ".$self->foldername." $num\n" if ($verbose);
   my $start = $info->{'Posn'};
   my $end   = $start + $info->{'Length'};
   my $fh = $self->getFH($start,0);
   my @data = ();
   while (tell($fh) < $end && defined($_ = <$fh>))
    {
     push(@data,$_);
    }
   close($fh);
   $msg = Mail::Internet->new(\@data,Modify => 0);
   $info->{'message'} = $msg;
  }
 my $status = $info->{'newstatus'};
 my $hdr = $msg->head;
 $hdr->replace('X-Mozilla-Status',sprintf("%04x",$status));
 my $len = $hdr->get('Content-Length');
 if (defined($len))
  {
   my $cl = $info->{'Content-Length'};
   if (defined($cl) && $cl != $len)
    {
     warn "Set Content-Length to $cl (was $len)\n";
     $hdr->replace('Content-Length',$info->{'Content-Length'});
    }
  }
 return $msg;
}

sub get_header
{
 my ($self,$num) = @_;
 my $msg = $self->get_message($num);
 return undef unless defined $msg;
 return $msg->head;
}

sub open
{
 my ($self,$path) = @_;
 my $fh = do { local *FH };
 CORE::open($fh,(-f $path) ? "+<$path" : "+>$path");
 croak("Cannot open $path:$!") unless $fh;
 close($fh);
 $self->SUPER::open($path);
 $self->{'PathName'} = $path;
 eval { $self->read_summary };
 warn $@ if $@;
 $self->build_summary if $@;
 $self->read_mbox;
}

sub unread
{
 my $self = shift;
 return $self->{'Summary'}{'Unread'};
}

sub qty
{
 my $self = shift;
 return $self->{'Summary'}{'NumMessages'};
}

sub dot_name
{
 my ($self,$suffix) = @_;
 my $path   = $self->foldername;
 $path    =~ s#([^/\\]+)$#.$1.$suffix#;
 return $path;
}

sub summary_path
{
 my ($self) = @_;
 my $path   = $self->foldername;
 if ($^O eq 'MSWin32')
  {
   return $path . '.snm';
  }
 else
  {
   return $self->dot_name('summary');
  }
}

sub write_summary
{
 my $self = shift;
 my $summary = $self->{'Summary'};
 croak("No summary") unless $summary;
 my $path   = (@_) ? shift : $self->summary_path;
 my $fh = do { local *SUM };
 CORE::open($fh,">$path") || die "Cannot open $path:$!";
 binmode($fh);
 warn "Writing $path\n";
 local $SIG{'__WARN__'} = \&Carp::confess;
 local $SIG{'__DIE__'} = \&Carp::confess;
 print $fh $MAGIC;
 ns_put_long($fh,4);
 ns_put_long($fh,$summary->{'MBoxSeen'});
 ns_put_long($fh,$summary->{'MBoxTime'});
 ns_put_long($fh,$summary->{'MBoxSize'});
 my $sumcnt = $summary->{'SummaryCount'};
 ns_put_long($fh,$sumcnt);
 ns_put_long($fh,$summary->{'NumMessages'});
 ns_put_long($fh,$summary->{'Unread'});
 ns_put_long($fh,$summary->{'Wasted'});
 my @strings;
 my %strings;
 if ($sumcnt)
  {
   $strings{''} = @strings;
   push(@strings,"\0");
   for (my $i = 1; $i <= $sumcnt ; $i++)
    {
     my $info = $summary->{'Messages'}[$i];
     if ($info)
      {
       foreach my $key (qw(From To Subject Message-Id))
        {
         my $str = $info->{$key} || '';
         if (!exists($strings{$str}))
          {
           $strings{$str} = @strings;
           push(@strings,"$str\0");
          }
        }
       if (exists $info->{'References'})
        {
         foreach my $str (@{$info->{'References'}})
          {
           if (!exists($strings{$str||''}))
            {
             $strings{$str} = @strings;
             push(@strings,"$str\0");
            }
          }
        }
      }
    }
  }
 ns_put_short($fh,scalar(@strings));
 foreach my $str (@strings)
  {
   print $fh $str;
  }
 for (my $i = 1; $i <= $sumcnt ; $i++)
  {
   my $info = $summary->{'Messages'}[$i];
   if ($info)
    {
     ns_put_short($fh,$strings{$info->{'From'}||''});
     ns_put_short($fh,$strings{$info->{'To'}||''});
     ns_put_short($fh,$strings{$info->{'Subject'}||''});
     ns_put_long($fh,$info->{'time'});
     ns_put_long($fh,$info->{'newstatus'});
     ns_put_long($fh,$info->{'Posn'});
     ns_put_long($fh,$info->{'Length'});
     ns_put_short($fh,$info->{'StatOff'});
     ns_put_short($fh,$info->{'Content-Lines'});
     ns_put_short($fh,$strings{$info->{'Message-Id'}||''});
     if (exists $info->{'References'})
      {
       my @refs = @{$info->{'References'}};
       ns_put_short($fh,scalar(@refs));
       foreach my $str (@refs)
        {
         ns_put_short($fh,$strings{$str||''});
        }
      }
     else
      {
       ns_put_short($fh,0);
      }
    }
  }
 $summary->{'NeedWrite'} = 0;
 close($fh);
}

sub update_db
{
 my ($statusdb,$summary,$data,$flags) = @_;
 my $this = $data->{'status'};
 return $this if ($this & NS_DELETED);
 my $id   = $data->{'Message-Id'};
 if (defined($id) && length($id))
  {
   $flags = 3 unless defined $flags;
   my $old = ($statusdb->{$id}||0)+0;
   $old &= ~NS_DELETED;
   my $new = ($flags == 1) ? $this : ($flags == 2) ? $old : ($this | $old);
   if ($flags & 1 && $old != $new)
    {
     print "DB <$id> : $old | $this => $new\n";
     $statusdb->{$id} = $new;
    }
   if ($flags & 2 && $this != $new)
    {
     print "MB <$id> : $old | $this => $new\n";
     $data->{'newstatus'} = $new;
     $summary->{'StatusChange'} = 1;
     return $new;
    }
  }
 return $this;
}

sub read_summary
{
 my ($self) = @_;
 my $path   = $self->summary_path;
 return $self->build_summary unless -f $path;
 my $fh = do { local *SUM };
 CORE::open($fh,$path) || die "Cannot open $path:$!";
 binmode($fh);
 my $magic = <$fh>;
 my %summary = ('path' => $path );
 my $first_unread  = 0;
 my $first_flagged = 0;
 die "$path: Bad header\n" unless ($magic eq $MAGIC);
 my $ver  = ns_get_long($fh);
 die "$path: Bad version ($ver not 4)\n" unless ($ver == 4);
 warn "Reading $path\n";
 my @strings;
 my $statusdb = statusdb();
 $summary{'NeedWrite'} = 0;
 $summary{'StatusChange'} = 0;
 $summary{'MBoxSeen'}  = ns_get_long($fh);
 $summary{'MBoxTime'}  = ns_get_long($fh);
 $summary{'MBoxSize'}  = ns_get_long($fh);
 my $sumcnt = $summary{'SummaryCount'}  = ns_get_long($fh);
 $summary{'NumMessages'}  = ns_get_long($fh);
 $summary{'Unread'}  = ns_get_long($fh);
 $summary{'Wasted'}  = ns_get_long($fh);

 my $scount = ns_get_short($fh);

 for (my $i = 0; $i < $scount; $i++)
  {
   $strings[$i] = ns_get_string($fh);
  }

 my @message;
 $summary{'Messages'} = \@message;
 $self->{'Summary'} = \%summary;

 for (my $i = 1; $i <= $sumcnt; $i++)
  {
   my %head;
   $head{'From'}    = $strings[ns_get_short($fh)];
   $head{'To'}      = $strings[ns_get_short($fh)];
   $head{'Subject'} = $strings[ns_get_short($fh)];
   $head{'time'}    = ns_get_long($fh);
   my $status       = ns_get_long($fh);
   $head{'status'}    = $status;
   $head{'newstatus'} = $status;
   $head{'Posn'}    = ns_get_long($fh);
   $head{'Length'}  = ns_get_long($fh);
   $head{'StatOff'} = ns_get_short($fh);
   $head{'Content-Lines'}   = ns_get_short($fh);
   my $id = $strings[ns_get_short($fh)];
   $head{'Message-Id'} = $id;
   my $refs = ns_get_short($fh);
   if ($refs)
    {
     my @refs;
     while ($refs--)
      {
       push(@refs,$strings[ns_get_short($fh)]);
      }
     $head{'References'} = \@refs;
    }
   $message[$i] = \%head;
   $self->remember_message($i);

   $status = update_db($statusdb,\%summary,\%head,3);

   if ($status & NS_DELETED)
    {
     $self->add_label($i,'deleted');
    }
   unless ($status & NS_READ)
    {
     $self->add_label($i,'unread');
     $first_unread ||= $i unless ($status & NS_DELETED);
    }
   if ($status & NS_FLAGGED)
    {
     $self->add_label($i,'flagged');
     $first_flagged ||= $i unless ($status & NS_DELETED);
    }
  }
 warn "$path: Not at EOF" unless eof($fh);
 close($fh);
 $self->current_message($first_unread || $first_flagged || $sumcnt);
 syncdb();
 return $self->{'Summary'};
}

sub try_time
{
 my $date = shift;
 my $time;
 eval { $time = str2time($date) };
 return ($@) ? undef : $time;
}

use Carp;

sub decode_time
{
 my ($date,$strict) = @_;
 my $time;
 local $SIG{'__DIE__'} = \&Carp::confess;

 if (defined $date)
  {
   my $time = parsedate($date,FUZZY => 1);
   $time = str2time($date) unless $time;
   return $time if defined $time;
   warn "Cannot convert '$date'\n" if $strict;
  }
 return undef;
}

sub old_decode_time
{
 my $orig = shift;
 my $date = $orig;
 my $time;
 if (defined $date)
  {
   $date =~ s/\b(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s+(\d{3})\s/"$1 ".($2+1900).' '/e;
   $date =~ s/\+(-\d+)/$1/g;
   my $time = try_time($date);
   return $time if defined $time;
   # Loose 'From ' type prefix.
   if ($date =~ s/^\s*(-|\S+\@\S+|[-\w\.]+)//)
    {
     $time = try_time($date);
     return $time if defined $time;
    }
   $date =~ s/["'\s]+/ /g;
   if ($date =~ s/\s([+-])(\d+)\s*$/sprintf(" $1%02d00",$2)/e)
    {
     $time = try_time($date);
     return $time if defined $time;
    }
   if ($date =~ s/([+-]|)(\d+)\.(\d+)\s*$/sprintf("$1%02d%02d",$2,$3)/e)
    {
     $time = try_time($date);
     return $time if defined $time;
    }
   if ($date =~ s/GMT([+-]\d+)\s*$/$1/)
    {
     $time = try_time($date);
     return $time if defined $time;
    }
   # Loose what looks like trailing timezone ...
   if ($date =~ s/\s*[A-Z]+(\d+[A-Z]+)?\s*$//)
    {
     $time = try_time($date);
     return $time if defined $time;
    }
   if ($date =~ s/(\d+):(\d+):(\d+)/sprintf('%02d:%02d:%02d',$1,$2,$3)/e)
    {
     $time = try_time($date);
     return $time if defined $time;
    }
   # Try things like Central Standard Time => CST
   if ($date =~ s/\b([A-Z])[a-z]+\s+([A-Z])[a-z]+\s+([A-Z])[a-z]+\b\s*$/$1$2$3/)
    {
     $time = try_time($date);
     return $time if defined $time;
    }
   warn "Cannot convert '$date' ('$orig')" unless defined $time;
  }
 return undef;
}

my $seq = 0;
sub genId
{
 my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
 $seq++;
 my $id = sprintf("Tkmail.$$-$seq.%04d-%02d-%02d.%02d:%02d:%02d",
                 $year+1900,$mon+1,$mday,$hour,$min,$sec);
 warn "Generate $id\n";
 return $id;
}

sub read_mbox
{
 my $self = shift;
 my $fh    = $self->getFH;
 return unless $fh;
 my @stat  = stat($fh);
 my $end   = $stat[7];
 my $summary = $self->{'Summary'};
 my $num   = $summary->{'SummaryCount'};
 my $start = $summary->{'MBoxSeen'};
 if ($end < $start)
  {
   warn "Mailbox smaller than cached size\n";
   $self->build_summary;
  }
 if (0 && defined($summary->{'MBoxTime'}) && $stat[9] != $summary->{'MBoxTime'})
  {
   warn "Time-stamp mis-match\n";
   $self->build_summary;
  }
 if ($end > $start)
  {
   my $statusdb = statusdb();
   require Mail::Address;
   seek($fh,$start,0);
   my $posn = tell($fh);
   my $data;
   my $first_flagged = 0;
   my $first_unread = 0;
   # warn sprintf("Reading %s @ %d to %d\n",$self->foldername,$start,$end);
   while ($posn = tell($fh),defined($_ = <$fh>))
    {
     if (/^From \s*\S+\s*(.*)$/)
      {
       $data = {'Posn' => $posn,
                'StatOff' => 0,
                'Subject' => '',
                'From' => '',
                'To' => '',
                'status' => 0,
                'Message-Id' => '',
                'time' => decode_time($1,0)
               };
      }
     elsif (/^(From|Date|To|Subject|Message-Id|References|X-Mozilla-Status|Content-Length):\s*(.*)$/i)
      {
       next unless $data;
       my ($tag,$val) = ($1,$2);
       $tag =~ s/([A-Za-z]+)/ucfirst(lc($1))/ge;
       if ($tag eq 'Date')
        {
         my $t = decode_time($val,1);
         $data->{'time'} = $t if (defined $t);
        }
       elsif ($tag eq 'X-Mozilla-Status')
        {
         die "No posn" unless (defined $posn);
         die "No data" unless (defined $data);
         die "No Posn" unless (defined $data->{'Posn'});
         $data->{'StatOff'} = $posn - $data->{'Posn'};
         $tag = 'status';
         $val = hex($val);
        }
       elsif ($tag eq 'From' or $tag eq 'To')
        {
         my $addr = (Mail::Address->parse($val))[0];
         if ($addr)
          {
           $val = $addr->phrase || $addr->comment || $addr->address;
          }
        }
       elsif ($tag eq 'References')
        {
         $val =~ s/(^\s+|\s$)//g;
         my @refs = split(/\s/,$val);
         foreach (@refs)
          {
           s/^\s*<?//;
           s/>?[\s\r\n]*$//;
          }
         unshift(@refs,@{$data->{$tag}}) if exists $data->{$tag};
         $val = \@refs;
        }
       elsif ($tag eq 'Message-Id')
        {
         $val =~ s/^\s*<?//;
         $val =~ s/>?[\s\r\n]*$//;
        }
       $data->{$tag} = $val;
      }
     elsif (/^\r?\n/ || eof($fh))
      {
       next unless $data;
       my $lines = 0;
       my $len = $data->{'Content-Length'};
       if (defined($len) && $len =~/\s*\d+\s*$/)
        {
         my $end = tell($fh)+$len;
         my $cnt = 0;
         while (($posn = tell($fh)) < $end && defined($_ = <$fh>))
          {
	   if (/^From .*\@.*\b\d{4}\b/ && /\b(Sat|Sun|Mon|Tue|Wed|Thu|Fri)/)
	    {
             warn "Stop at $_\n";
             seek($fh,$posn,0);
  	     last;
	    }
           if (/^From /)
            {
             warn "Un-escaped 'From ' in message body\n";
            }
           $cnt += length($_);
           $lines++;
          }
         if ($len != $cnt)
          {
           warn "Content length seems to be $cnt not $len\n";
           $data->{'Content-Length'} = $cnt;
          }
        }
       else
        {
         $len = 0;
         while ($posn = tell($fh),defined($_ = <$fh>))
          {
           if (/^From /)
            {
             seek($fh,$posn,0);
             last;
            }
           $len += length($_);
           $lines++;
          }
         $data->{'Content-Length'} = $len;
        }
       $data->{'Content-Lines'} = $lines;
       $data->{'time'} = $stat[9] unless (defined $data->{'time'});
       $data->{'Length'} = tell($fh) - $data->{'Posn'};
       $data->{'status'} = 0 unless exists  $data->{'status'};
       my $status = $data->{'status'};
       $data->{'newstatus'} = $status;
       my $id = $data->{'Message-Id'};
       if (!$id)
        {
         $data->{'Message-Id'} = $id = genId();
        }

       $status = update_db($statusdb,$summary,$data,2);

       $num++;
       $summary->{'Messages'}[$num] = $data;
       $summary->{'NeedWrite'} = 1;
       $self->remember_message($num);
       if ($status & NS_DELETED)
        {
         $summary->{'Wasted'} += $data->{'Length'};
         $self->add_label($num,'deleted');
        }
       else
        {
         $summary->{'NumMessages'}++;
        }
       unless ($status & NS_READ)
        {
         $self->add_label($num,'unread');
         $first_unread ||= $num unless ($status & NS_DELETED);
         $summary->{'Unread'}++;
        }
       if ($status & NS_FLAGGED)
        {
         $self->add_label($num,'flagged');
         $first_flagged ||= $num unless ($status & NS_DELETED);
        }
       $data = undef;
      }
    }
   $summary->{'MBoxSeen'} = $end;
   $summary->{'MBoxTime'} = $stat[9];
   $summary->{'MBoxSize'} = $end;
   $summary->{'SummaryCount'} = $num;
   my $cur = $self->current_message;
   if (!$self->label_exists($cur,'unread'))
    {
     if ($first_unread)
      {
       $self->current_message($first_unread);
      }
     else
      {
       if (!$self->label_exists($cur,'flagged'))
        {
         if ($first_flagged)
          {
           $self->current_message($first_flagged);
          }
        }
      }
    }
  }
 close($fh);
 syncdb();
}

sub build_summary
{
 my $self = shift;
 $self->{'Summary'} = { 'MBoxSeen' => 0,
                        'MBoxTime' => undef,
                        'MBoxSize' => 0,
                        'SummaryCount' => 0,
                        'Messages' => [],
                        'NumMessages' => 0,
                        'Unread' => 0,
                        'Wasted' => 0,
                        'NeedWrite' => 0,
                        'StatusChange' => 0
                      };
 $self->delete_tmp;
 $self->read_mbox;
}

sub update_status
{
 my ($self) = @_;
 my $fh = $self->getFH;
 return unless $fh;
 my $summary = $self->{'Summary'};
 return unless $summary;
 if ($summary->{'StatusChange'})
  {
   my $unread = 0;
   my $statusdb = statusdb();
   foreach my $msg (@{$summary->{'Messages'}})
    {
     next unless $msg;
     if ($msg->{'newstatus'} != $msg->{'status'})
      {
       my $posn = $msg->{'Posn'} + $msg->{'StatOff'};
       seek($fh,$posn,0);
       my $line = <$fh>;
       if ($line =~ /^(X-Mozilla-Status\s*:\s*)[0-9a-f]{4}(\s*)$/)
        {
         my $new = sprintf("$1%04x$2",$msg->{'newstatus'});
         if (length($line) != length($new))
          {
           warn "Old:$line";
           die  "New:$new";
          }
         else
          {
           seek($fh,$posn,0);
           print $fh $new;
           # $fh->flush;
           $msg->{'status'} = $msg->{'newstatus'};
           $summary->{'NeedWrite'} = 2;
          }
         update_db($statusdb,$summary,$msg,1);
        }
       else
        {
         my $path   = $self->foldername;
         warn("$path\nExpected status got:$line");
        }
      }
     $unread++ unless $msg->{'status'} & NS_READ;
    }
   if ($unread != $summary->{'Unread'})
    {
     $summary->{'Unread'} = $unread;
     $summary->{'NeedWrite'} = 1;
    }
   $summary->{'StatusChange'} = 0;
  }
 if ($summary->{'NeedWrite'})
  {
   seek($fh,0,2);
   # $fh->flush;
   $summary->{'MBoxTime'} = (stat($fh))[9];
   $self->write_summary;
  }
 close($fh);
 syncdb();
}

sub close
{
 my $self = shift;
 $self->delete_tmp;
 $self->update_status;
 $self->SUPER::close(@_);
}

sub NotImplemented
{
 my $sub = (caller(1))[3];
 croak("$sub not implemeted");
}

sub PrintArgs
{
 package DB;
 my $sub = (caller(1))[3];
 print "$sub(",join(',',@DB::args),")\n";
}

my %label  = ( 'deleted' => NS_DELETED,
               'unread'  => -NS_READ(),
               'flagged' => NS_FLAGGED
             );

sub _label
{
 my ($self,$key,$lab,$off) = @_;
 my $bit = $label{$lab};
 if (defined $bit)
  {
   $bit = -$bit if ($off);
   my $info = $self->_summary($key);
   die("Bad key $key") unless $info;
   my $status = $info->{'newstatus'};
   if ($bit < 0)
    {
     $bit = -$bit;
     if ($status & $bit)
      {
       my $summary = $self->{'Summary'};
       $summary->{'StatusChange'} = 1;
       if ($bit == NS_READ)
        {
         $summary->{'Unread'}++;
        }
       $info->{'newstatus'} = $status & ~$bit;
      }
    }
   else
    {
     unless ($status & $bit)
      {
       my $summary = $self->{'Summary'};
       $summary->{'StatusChange'} = 1;
       if ($bit == NS_READ)
        {
         $summary->{'Unread'}--;
        }
       $info->{'newstatus'} = $status | $bit;
      }
    }
  }
 else
  {
   carp("$lab will not persist");
  }
}

sub add_label
{
 my $self = shift;
 if ($self->SUPER::add_label(@_))
  {
   $self->_label(@_,0);
  }
 return 1;
}

sub delete_label
{
 my $self = shift;
 if ($self->SUPER::delete_label(@_))
  {
   $self->_label(@_,1);
  }
 return 1;
}

sub delete_message
{
 my $self = shift;
 if ($self->SUPER::delete_message(@_))
  {
   my $summary = $self->{'Summary'};
   return 0 unless $summary;
   $summary->{'NumMessages'}--;
  }
 return 1;
}

sub undelete_message
{
 my $self = shift;
 if ($self->SUPER::undelete_message(@_))
  {
   my $summary = $self->{'Summary'};
   return 0 unless $summary;
   $summary->{'NumMessages'}++;
  }
 return 1;
}

use Data::Dumper;
sub append_message
{
 my $self = shift;
 if ($self->SUPER::append_message(@_))
  {
   my $msg = shift;
   if ($msg)
    {
     my $fh = $self->getFH(0,2);
     return 0 unless $fh;
     my $head = $msg->head;
     my $id = $head->get('Message-Id');
     unless ($id)
      {
       $id = genId();
       $head->replace('Message-Id',$id);
      }
     $msg->print($fh);
     CORE::close($fh);
     $self->read_mbox;
    }
   return 1;
  }
 return 0;
}

sub update_message
{
 my $self = shift;
 if ($self->SUPER::update_message(@_))
  {
   my ($num,$msg) = @_;
   if ($msg)
    {
     if ($self->append_message($msg))
      {
       $self->delete_message($num);
       return 1;
      }
    }
  }
 return 0;
}

sub delete_tmp
{
 my $self = shift;
 if (exists $self->{'Files'})
  {
   while (@{$self->{'Files'}})
    {
     my $path = pop(@{$self->{'Files'}});
     unlink($path) if (defined $path);
    }
  }
}

sub sync
{
 my $self = shift;
 $self->update_status;
 $self->read_mbox;
 return $self->SUPER::sync(@_);
}

sub sort_method
{
 my $self = shift;
 my $method = shift;
 return sort { $self->$method($a) <=> $self->$method($b) } $self->message_list;
}

sub sort_time
{
 my $self = shift;
 my $method = shift;
 return sort { $self->message_time($a) <=> $self->message_time($b) } $self->message_list;
}

sub pack
{
 my $self = shift;
 if ($self->SUPER::pack(@_))
  {
   my $del = $self->first_labeled_message('deleted');
   return 0 unless $del;
   warn "Packing ".$self->foldername." starting at $del\n";
   my $myname  = $self->foldername;
   my $newname = $self->dot_name('new');
   my $nf = Mail::Folder->new('netscape',$newname);
   if ($nf)
    {
     my $sum = $self->summary_path;
     my $oldname = $self->dot_name('old');
     my $nsum = $nf->summary_path;
     my $changes = 0;
     foreach my $num ($self->sort_time)
      {
       unless ($self->label_exists($num,'deleted'))
        {
         my $mail = $self->get_message($num);
         $nf->append_message($mail) if $mail;
        }
      }
     $nf->close;
     $self->close;
     unlink($oldname) if (-f $oldname);
     rename($myname,$oldname) || die "Cannot rename $myname to old $oldname:$!";
     rename($newname,$myname) || die "Cannot rename $newname to my $myname:$!";
     unlink($sum);
     rename($nsum,$sum) || warn "Cannot rename sum $nsum to $sum:$!";
     $self->open($myname);
     return 1;
    }
   else
    {
     die "Cannot open $newname:$!";
    }
  }
 return 0;
}

sub DESTROY
{
 my $self = shift;
 my $path  = $self->{'PathName'};
 $self->close if (defined($path) && -f $path);
}

sub _update_content_length
{
 my ($self,$msg) = @_;
 my $hdr = $msg->head;
 unless ($hdr->get('X-Mozilla-Status'))
  {
   $hdr->add('X-Mozilla-Status',sprintf("%04x",0));
  }
 unless ($hdr->get('From '))
  {
   my $who = '-';
   my $f = $hdr->get('From');
   if (defined $f)
    {my @a = Mail::Address->parse($f);
     $who = $a[0]->address if (@a);
    }
   my $d = $hdr->get('Date') || localtime(time)."\n";
   $hdr->add('From ',"$who $d",0);
  }
}

sub default_directory
{
 return "$ENV{'HOME'}/tkmail";
}

sub delete
{
 my ($self) = @_;
 my $path    = $self->foldername;
 my $newname = $self->dot_name('del');
 $self->close;
 if (rename($path,$newname))
  {
   warn "Renamed to $newname\n";
   my $sum     = $self->summary_path;
   unlink($sum) if -f $sum;
   return 1;
  }
 else
  {
   warn "Cannot rename $path:$!";
  }
 return 0;
}

1;

__END__







