#!/usr/bin/perl
use warnings;
use strict;

use Mail::Message;
use Data::Dumper;
use Mail::Message::Body::String;
use Mutulate;

$Data::Dumper::Indent = 1; 

my $msg   = Mail::Message->read(scalar `cat msg`);
$msg->printStructure;

my $plain = msg_mutulate $msg
  , invalidate_plain_alternative    => 50
  , always_remove_plain_alternative => 0
  , remove_html_alternative         => 1
  , add_plain_alternative_for_html  => 1
  ;

print "******\n";
#$plain->print;
print "#######\n";
$plain->printStructure;

# $plain is now a normal plain text message, but is still registered as nested
print "I am a nested message"
    if $plain->body->isNested;

exit 0;

$plain = strip_attachments($plain, strip_nested=>1);

# After strip_attachments (which shouldn't do anything)
# there is nothing left:
print $plain->decoded;

