# This code is part of Perl distribution Mail-Box-POP3 version 3.008.
# The POD got stripped from this file by OODoc version 3.05.
# For contributors see file ChangeLog.

# This software is copyright (c) 2001-2025 by Mark Overmeer.

# This is free software; you can redistribute it and/or modify it under
# the same terms as the Perl 5 programming language system itself.
# SPDX-License-Identifier: Artistic-1.0-Perl OR GPL-1.0-or-later

#oodist: *** DO NOT USE THIS VERSION FOR PRODUCTION ***
#oodist: This file contains OODoc-style documentation which will get stripped
#oodist: during its release in the distribution.  You can use this file for
#oodist: testing, however the code of this development version may be broken!

package Mail::Box::POP3::Message;{
our $VERSION = '3.008';
}

use base 'Mail::Box::Net::Message';

use strict;
use warnings;

#--------------------

sub init($)
{	my ($self, $args) = @_;

	$args->{body_type} ||= 'Mail::Message::Body::Lines';

	$self->SUPER::init($args);
	$self;
}


sub size($)
{	my $self = shift;

	$self->isDelayed;
		or return $self->SUPER::size;

	$self->folder->popClient->messageSize($self->unique);
}

sub label(@)
{	my $self = shift;
	$self->loadHead;              # be sure the labels are read
	return $self->SUPER::label(@_) if @_==1;

	# POP3 can only set 'deleted' in the source folder.  Don't forget
	my $olddel = $self->label('deleted') ? 1 : 0;
	my $ret    = $self->SUPER::label(@_);
	my $newdel = $self->label('deleted') ? 1 : 0;

	$self->folder->popClient->deleted($newdel, $self->unique)
		if $newdel != $olddel;

	$ret;
}

sub labels(@)
{	my $self = shift;
	$self->loadHead;              # be sure the labels are read
	$self->SUPER::labels(@_);
}

#--------------------

sub loadHead()
{	my $self     = shift;
	my $head     = $self->head;
	$head->isDelayed or return $head;

	$head        = $self->folder->getHead($self);
	$self->head($head);

	$self->statusToLabels;  # not supported by al POP3 servers
	$head;
}

sub loadBody()
{	my $self     = shift;

	my $body     = $self->body;
	$body->isDelayed or return $body;

	(my $head, $body) = $self->folder->getHeadAndBody($self);
	$self->head($head) if $head->isDelayed;
	$self->storeBody($body);
}

1;
