#oodist: *** DO NOT USE THIS VERSION FOR PRODUCTION ***
#oodist: This file contains OODoc-style documentation which will get stripped
#oodist: during its release in the distribution.  You can use this file for
#oodist: testing, however the code of this development version may be broken!

package Mail::Server::IMAP4::User;
use parent 'Mail::Box::Manage::User';

use strict;
use warnings;

use Log::Report 'mail-box-imap4';

#--------------------
=chapter NAME

Mail::Server::IMAP4::User - manage the folders of one user

=chapter SYNOPSIS

  my $mgr = Mail::Server::IMAP4::User->new(...);

=chapter DESCRIPTION

This class adds IMAP protocol features to the normal Mail::Box::Manager.

=chapter METHODS

=c_method new %options
=option  index_filename FILENAME
=default index_filename C<$folderdir/index>
=cut

sub init($)
{	my ($self, $args) = @_;
	$self->SUPER::init($args) or return ();
	$self->{MSNU_indexfile} = $args->{indexfile} // ($self->folderdir . '/index');
	$self;
}

#--------------------
=section Attributes

=method indexFilename
Returns the filename of the index file.
=cut

sub indexFilename() { $_[0]->{MSNU_indexfile} };

#--------------------
=section Manage folders

=method folderInfo $name
Returns a hash with folder information.  In normal circumstances, it is
cheap to get these details, because they are cached in an index file.
DO NOT modify the values you find in the hash, because that data may
or may not be lost.

DO NOT trust on the existence of any field in the info: fields may get
renamed, removed, or added over time.  Not all folder indexes will be
generated by the same software release.

=example how to get global info about a folder
  my $info = $user->folderInfo($name); # get info
=cut

sub folderInfo($)
{	my $index = $_[0]->index or return ();
	$index->folder(shift);
}

=method delete $name, %options
Remove all signs from the folder on the file-system.  Messages still in
the folder will be removed.  This method returns a true value when the
folder has been removed or not found, so "false" means failure.

It is also possible to delete a folder using C<< $folder->delete >>, which
will call this method here.  The %options, which are used for some other folder
types, will be ignored here: the user's index contains the required details.

=example how to delete a folder
  print "no xyz (anymore)\n" if $user->delete('xyz');

=fault unable to remove folder {$name}
=cut

sub delete($)
{	my ($self, $name) = @_;
	my $index = $self->index->startModify or return 0;

	unless($self->_delete($index, $name))
	{	$self->cancelModification($index);
		return 0;
	}

	$index->write;
}

sub _delete($$)
{	my ($self, $index, $name) = @_;

	# First clean all subfolders recursively
	foreach my $subf ($index->subfolders($name))
	{	$self->_delete($index, $subf) or return 0;
	}

	# Already disappeared?  Shouldn't happen, but ok
	my $info  = $index->folder($name)
		or return 1;

	# Bluntly clean-out the directory
	if(my $dir = $info->{Directory})
	{	# Bluntly try to remove, but error is not set
		if(remove(\1, $dir) != 0 && -d $dir)
		{	fault __x"Unable to remove folder {name}", name => $dir;
			return 0;
		}
	}

	# Remove (sub)folder from index
	$index->folder($name, undef);
	1;
}

=method create $name, %options
Creates a new folder with the specified name.  Folder info is returned,
which will be very simple.  In the accidental case that the folder already
exists, a warning will be issued, and that folder's data returned.

=warning folder $name already exists, creation skipped.
=fault   cannot create folder directory $dir: $!
=fault   cannot write name for folder in $file: $!
=fault   failed writing folder name to $file: $!
=cut

sub create($@)
{	my ($self, $name) = (shift, shift);
	my $index   = $self->index->startModify or return undef;

	if(my $info = $index->folder($name))
	{	warning __x"folder {name} already exists, creation skipped.", name => $name;
		return $info;
	}

	my $uniq    = $index->createUnique;

	# Create the directory
	# Also in this case, we bluntly try to create it, and when it doesn't
	# work, we check whether we did too much. This may safe an NFS stat.

	my $dir     = $self->home . '/F' . $uniq;
	-d $dir or mkdir $dir, 0750
		or fault __x"cannot create folder directory {dir}", dir => $dir;

	# Write folder name in directory, for recovery purposes.
	my $namefile = "$dir/name";
	my $namefh;
	open $namefh, '>:encoding(utf-8)', $namefile
		or fault __x"cannot write name for folder in {file}", file => $namefile;

	$namefh->print("$name\n");

	$namefh->close
		or fault __x"failed writing folder name to {file}", file => $namefile;

	# Add folder to the index

	my $facts = $self->folder(
		$name,
		Folder    => $name,
		Directory => $dir,
		Messages  => 0,
		Size      => 0,
	);

	$self->write && $facts;
}

#--------------------
=chapter DETAILS

=section The folder table

=cut

1;
